﻿using System;
using System.Globalization;
using System.Linq;

namespace CultureExamples
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 10-46. Prezentacja dostępnych ustawień kulturowych.
            var cultures = CultureInfo.GetCultures(CultureTypes.AllCultures).
                OrderBy(c => c.EnglishName);
            foreach (var culture in cultures)
            {
                Console.WriteLine("{0} : {1}", culture.EnglishName, culture.Name);
            }

            // Listing 10-47. Formatowanie liczb w różnych ustawieniach kulturowych.
            CultureInfo englishUS = CultureInfo.CreateSpecificCulture("en-US");
            CultureInfo french = CultureInfo.CreateSpecificCulture("fr");
            double value = 1.8;
            Console.WriteLine(value.ToString(englishUS));
            Console.WriteLine(value.ToString(french));
        }
    }
}
